VERSION 5.00
Begin VB.Form frmMain 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Create Trial Application 2"
   ClientHeight    =   2190
   ClientLeft      =   5385
   ClientTop       =   2910
   ClientWidth     =   3975
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2190
   ScaleWidth      =   3975
   Begin VB.CommandButton cmdRegMethod 
      Caption         =   "    Register    Without Trial Period"
      Height          =   750
      Left            =   330
      Style           =   1  'Graphical
      TabIndex        =   2
      ToolTipText     =   " Used to register the application without using a trial period "
      Top             =   1200
      Width           =   1470
   End
   Begin VB.CommandButton cmdDelete 
      Caption         =   " Delete  Registration Information"
      Height          =   750
      Left            =   2175
      Style           =   1  'Graphical
      TabIndex        =   3
      ToolTipText     =   " Delete all registration information "
      Top             =   1200
      Width           =   1470
   End
   Begin VB.CommandButton cmdValues 
      Caption         =   "Current Registration Values"
      Height          =   750
      Left            =   2175
      Style           =   1  'Graphical
      TabIndex        =   1
      ToolTipText     =   " Display the current registration information "
      Top             =   225
      Width           =   1470
   End
   Begin VB.CommandButton cmdRegister 
      Caption         =   "Display Registration Form"
      Height          =   750
      Left            =   330
      Style           =   1  'Graphical
      TabIndex        =   0
      ToolTipText     =   " Show a sample registration screen "
      Top             =   225
      Width           =   1470
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
'
' Copyright  2002 David Scarmozzino
'      All Rights Reserved
' http://www.TheScarms.com/AppSentinel
'         TheScarms (TM)
'
' This source code may not be redistributed. Redistributing
' this source code is a violation of copyright laws.
'
' This sample program was designed to serve as an example
' of calling the various methods of the AppSentinel DLLs.
'
' It is not intended to be used "as is" in your production
' application. The actual logic and sequence of DLL method
' calls must be designed to suit your specific needs.

' Return values from the fRegister routine.
Private Const cregRegistered = 0
Private Const cregEvaluating = 1
Private Const cregExpired = 2
Private Const cregError = -99
Private Function fRegister(ByRef strError As String) As Long

    '
    '---------------------------------------------------------------------
    ' Check the registration status of your application.
    '
    ' Return:
    '   cregRegistered - Properly Registered.
    '   cregEvaluating - Not registered. Evaluation period not expired.
    '   cregExpired    - Not registered. Evaluation period expired.
    '   cregError      - Error occured.
    '
    '   strError       - Contains the error message on error.
    '---------------------------------------------------------------------
    '
    strError = ""
    fRegister = cregExpired
    On Error GoTo ErrorHandler

    ' Read/check registration information.
    If Not gobjAppSentinel.GetRegistrationInfo(strError) Then GoTo ErrorHandler
    If Not gobjAppSentinel.CheckRegistration(strError) Then GoTo ErrorHandler
    
    ' See if application is registered.
    If gobjAppSentinel.Registered Then
        fRegister = cregRegistered
        Exit Function
    End If
    
    If gobjAppSentinel.Expired Then
        ' Trial period has expired.
        fRegister = cregExpired
        
        ' Show registration form and recheck
        ' registration in case user just registered.
        frmRegister.Show vbModal
        If Not gobjAppSentinel.GetRegistrationInfo(strError) Then GoTo ErrorHandler
        If Not gobjAppSentinel.CheckRegistration(strError) Then GoTo ErrorHandler
        If gobjAppSentinel.Registered Then fRegister = cregRegistered
    Else
        'Still within trial period.
        fRegister = cregEvaluating
    End If
    Exit Function
    
ErrorHandler:
    ' A method of AppSentinel returned false. Assume
    ' your application is not registered or expired.
    fRegister = cregError
    If strError = "" Then strError = Err.Description
End Function
Private Sub cmdDelete_Click()
Dim strError    As String
Dim strPassword As String

    ' Remove all registration information.
    '
    ' This removes all registration info rendering your app
    ' un-registered reverting it to being in "evaluation mode"
    ' with a new trial period.
    '
    ' NOTE:
    ' ALL APPSENTINEL PROPERTIES ARE CLEARED BY THIS METHOD.
    '
    ' NOTE:
    '   THIS MUST BE THE LAST METHOD CALLED BEFORE RELEASING
    '   THE APPSENTINEL OBJECT. Otherwise, partial registration
    '   information will be recreated.
    '
    ' The FileMask and RegistrySubkey properties must be set before
    ' calling this method. In this sample they're set in frmMain.form_load.
    '
    ' The release DLL requires a valid password.
    strPassword = ""
    If Not gobjAppSentinel.DeleteRegistration(strPassword, strError) Then
        Call MsgBox(strError, vbCritical, "Delete Failed")
    End If

End Sub
Private Sub cmdRegister_Click()

    ' Show the registration screen.
    frmRegister.Show vbModal

End Sub
Private Sub cmdRegMethod_Click()
Dim strError    As String
Dim strPassword As String

    ' Register this application without an evaluation period.
    '
    ' The FileMask and RegistrySubkey properties must be set before
    ' calling this method. In this sample they're set in frmMain.form_load.
    '
    ' The release DLL requires a valid password.
    strPassword = ""
    If Not gobjAppSentinel.Register(strPassword, strError) Then
        Call MsgBox(strError, vbCritical, "Registration Failed")
    End If

End Sub
Private Sub cmdValues_Click()

    ' Display the registration values.
    frmValues.Show vbModal

End Sub
Private Sub Form_Load()
Dim lngResult As Long
Dim strTemp   As String
Dim strError  As String

    ' Only allow one instance of your app. Center the form.
    If App.PrevInstance Then End
    Call pCenterForm(Me)
    
    ' IMPORTANT:
    ' READ ObjectBinding.htm BEFORE RUNNING/CHANGING THIS CODE.
    
    'Set gobjAppSentinel = CreateObject("SEN10L.Registration")
    Set gobjAppSentinel = CreateObject("SEN10LT.Registration")
    '
    ' Set your evaluation period and required parameters.
    '
    ' Parameter       Description
    ' --------------  -------------------------------------------------
    ' FileMask        Required. Suggested length - 10 characters.
    '                 Used to create the names of the files which
    '                 store your application's registration data.
    '                 Mask should be unique. If AppSentinel is used in
    '                 more than one of your applications, use a
    '                 different mask in each application.
    '
    ' RegistrySubkey  Required. Typically: YourCompanyName\YourAppName
    '
    ' TrialDays*      Optional. The number of days to allow in your
    '                 evaluation period.
    ' TrialRuns*      Optional. The number of times your application
    '                 can be used during your evaluation period.
    '
    ' * TrialDays or TrialRuns or both must be set.
    '
    gobjAppSentinel.TrialDays = 20
    gobjAppSentinel.TrialRuns = 50
    gobjAppSentinel.FileMask = "YourFileMask3"
    gobjAppSentinel.RegistrySubkey = cSubKey
    
    ' Check the registration information.
    lngResult = fRegister(strError)
    
    Select Case lngResult
        Case cregRegistered
            ' App is registered. You may want to enable certain
            ' features, hide your registration screen,....
            'Call pDoRegistrationStuff()
            '
            ' You probably don't want to show this message.
            Call MsgBox("Your Application is Registered", vbInformation, "Registered Version")
        Case cregEvaluating
            ' Trial period has time and/or runs left.
            ' You can tell the user and tell them how to register.
            If gobjAppSentinel.DaysLeft <> "" Then
                strTemp = "You have " & gobjAppSentinel.DaysLeft & " day(s) remaining."
            End If
            If gobjAppSentinel.RunsLeft <> "" Then
                If strTemp <> "" Then strTemp = strTemp & vbCrLf
                strTemp = "You have " & gobjAppSentinel.RunsLeft & " run(s) remaining."
            End If
            Call MsgBox(strTemp, vbInformation, "Evaluation Version")
            
            ' You may want to show your nag screen, disable features,...
            'Call pDoEvaluationStuff()
        Case cregExpired
            ' Trial period expired.
            Call MsgBox("Your evaluation period has expired.", vbCritical, "Evaluation Period Expired")
            ' This sample has logic in fRegister to redisplay the
            ' registration form giving the user a chance to register.
            '
            ' NOTE:
            ' If you terminate your app using the END statement, you MUST
            ' Set gobjAppSentinel = Nothing first. See ObjectBinding.htm.
            Call MsgBox("This application will shut down.", vbCritical, "Evaluation Period Expired")
            Set gobjAppSentinel = Nothing
            Unload Me
        Case cregError
            ' Something went wrong. Tell the user.
            Call MsgBox(strError, vbCritical, "Error Verifying Registration")
            ' Assume the app is not registered and end your program.
            Set gobjAppSentinel = Nothing
            Unload Me
            ' If strError is an 'Internal Error', report the problem to
            ' Sales@TheScarms.com providing as much detail as possible.
    End Select

    ' Your normal Form_Load code goes here.
End Sub
Private Sub Form_Unload(Cancel As Integer)

    ' You MUST do this.
    Set gobjAppSentinel = Nothing
    
    Set frmMain = Nothing
End Sub


